> 比较数据中两个或多个组的比例

比例比较检验用于评估某些事件、行为、意图等的发生频率在不同组间是否存在差异。总体中组间比例差异的原假设设为零。我们使用样本数据检验这一假设。

我们可以执行单侧检验（即`小于`或`大于`）或双侧检验（见 “备择假设（Alternative hypothesis）” 下拉菜单）。单侧检验适用于评估样本数据是否表明，例如，某一无线运营商的掉话比例比其他运营商更高（或更低）。

### 示例

我们将使用泰坦尼克号乘客生存状态数据集的一个样本。泰坦尼克号乘客数据的主要来源是《泰坦尼克号百科全书》。原始来源之一是 Eaton & Haas（1994）的《泰坦尼克号：胜利与悲剧》（Patrick Stephens Ltd  出版），其中包含由多位研究者整理、经 Michael A. Findlay 编辑的乘客名单。我们关注数据中的两个变量：

- `survived` = 因子，水平为`Yes`（是）和`No`（否）
- `pclass` = 乘客等级（1 等、2 等、3 等），作为社会经济地位（SES）的替代指标：1 等≈上层；2 等≈中层；3 等≈下层

假设我们要检验泰坦尼克号沉没事件中，不同乘客等级的生存比例是否存在差异。为检验这一假设，我们选择`pclass`作为分组变量，并计算`survived`中`yes`的比例（见 “选择水平（Choose level）”）（见 “变量（选择一个）（Variable (select one)）”）。

在 “选择组合（Choose combinations）” 框中选择所有可用条目，对三个乘客等级进行两两比较。注意，移除所有条目会自动选择所有组合。除非我们对效应方向有明确假设，否则应使用双侧检验（即`two.sided`）。我们的第一个备择假设是 “1 等舱乘客的生存比例与 2 等舱乘客不同”。

<p align="center"><img src="figures_basics/compare_props_summary.png"></p>

输出的前两个区块显示检验的基本信息（如所选变量和置信水平）和汇总统计量（如每组的比例、标准误、误差边际等）。最后一个区块显示以下内容：

* `Null hyp.`是原假设，`Alt. hyp.`是备择假设
* `diff`是两组样本比例的差异（例如，0.635 - 0.441 = 0.194）。如果原假设为真，我们预期这一差异较小（即接近零）
* `p.value`是在原假设为真时，找到与`diff`一样极端或更极端值的概率

如果勾选 “显示额外统计量（Show additional statistics）”，会添加以下输出：

<pre>
Pairwise proportion comparisons
Data      : titanic 
Variables : pclass, survived 
Level     : Yes in survived 
Confidence: 0.95 
Adjustment: None 

 pclass Yes  No     p   n n_missing    sd    se    me
    1st 179 103 0.635 282         0 8.086 0.029 0.056
    2nd 115 146 0.441 261         0 8.021 0.031 0.060
    3rd 131 369 0.262 500         0 9.832 0.020 0.039

 Null hyp.   Alt. hyp.              diff  p.value chisq.value df 2.5%  97.5%    
 1st = 2nd   1st not equal to 2nd   0.194 < .001  20.576      1  0.112 0.277 ***
 1st = 3rd   1st not equal to 3rd   0.373 < .001  104.704     1  0.305 0.441 ***
 2nd = 3rd   2nd not equal to 3rd   0.179 < .001  25.008      1  0.107 0.250 ***

Signif. codes:  0 '***' 0.001 '**' 0.01 '*' 0.05 '.' 0.1 ' ' 1
</pre>

* `chisq.value`是与`diff`相关的卡方统计量，可与卡方分布比较。关于该指标的计算方法，详见 “基础> 表格 > 交叉表” 的帮助文件。每组组合都会计算等效的 2×2 交叉表。
* `df`是每个统计检验的自由度（1）。
* `2.5% 97.5%`显示样本比例差异的 95% 置信区间。这些数值提供了真实总体差异可能落入的范围。

### 检验方法

我们可以使用三种方法评估原假设。我们选择显著性水平为 0.05。<sup>1</sup> 当然，每种方法会得出相同结论。

#### p 值

由于每个两两比较的 p 值都**小于**显著性水平，基于可用样本数据，我们可以拒绝比例相等的原假设。结果表明，1 等舱乘客比 2 等舱和 3 等舱乘客更可能在沉没事件中幸存；同样，2 等舱乘客比 3 等舱乘客更可能幸存。

#### 置信区间

由于任何置信区间都**不**包含零，我们拒绝每个评估的乘客等级组合的原假设。

#### 卡方值

由于计算的卡方值（20.576、104.704 和 25.008）**大于**相应的临界卡方值，我们拒绝每个评估的乘客等级组合的原假设。可通过 “基础（Basics）” 菜单中的概率计算器获取临界卡方值。以 1 等舱与 2 等舱乘客的检验为例，我们发现对于自由度为 1（见`df`）、置信水平为 0.95 的卡方分布，临界卡方值为 3.841。

<p align="center"><img src="figures_basics/compare_props_prob_calc.png"></p>

除 “摘要（Summary）” 标签页中的数值输出外，我们还可以可视化研究`pclass`与`survived`之间的关联（见 “绘图（Plot）” 标签页）。下方截图显示两个条形图。第一个图表包含样本中`survived`为`yes`的比例的置信区间（黑色）和标准误（蓝色）条。与 “摘要” 标签页中的结果一致，不同乘客等级的生存率存在明显差异。“并列（Dodge）” 图表按乘客等级并排显示`survived`中`yes`和`no`的比例：1 等舱乘客中`yes`的比例高于`no`，而 3 等舱乘客则相反。

<p align="center"><img src="figures_basics/compare_props_plot.png"></p>

### 技术说明

- Radiant 使用 R 的`prop.test`函数进行比例比较。当一个或多个期望频数较小时（例如≤5），该检验的 p 值通过模拟方法计算。出现这种情况时，建议使用 “基础> 表格 > 交叉表” 重新运行检验，并评估是否有单元格的期望频数低于 1。
- 对于单侧检验（即`小于`或`大于`），临界值必须通过概率计算器中的正态分布获取，并对相应的 Z 统计量进行平方。

### 多重比较调整

我们评估的比较越多，即使原假设为真，仅因随机因素而发现 “显著” 结果的可能性就越大。如果我们进行 100 次检验，并将**显著性水平**设为 0.05（或 5%），即使总体中不存在关联，我们也可能预期有 5 个 p 值小于或等于 0.05。

邦费罗尼调整（Bonferroni adjustment）确保 p 值根据所进行的检验数量适当缩放。<a href="https://xkcd.com/882/"  target="blank">这幅 XKCD 漫画</a>清晰地说明了这类调整的必要性。

### 统计术语

这是**比例比较**检验，原假设为真实总体**比例差异**等于**0**。使用 0.05 的显著性水平，我们拒绝每个评估的乘客等级对的原假设，并得出结论：真实总体**比例差异不等于 0**。

1 等舱与 2 等舱乘客生存比例差异检验的 p 值为 **< .001**。这是在原假设为真时，观察到与数据中样本**比例差异**一样极端或更极端的样本**比例差异**的概率。在本例中，它是当真实总体**比例差异**为**0**时，观察到样本**比例差异**小于 **-0.194**或大于**0.194** 的概率。

95% 置信区间为**0.112**至**0.277**。如果重复抽样并为每个样本计算 95% 置信区间，真实**总体比例差异**将在 95% 的样本中落入置信区间内。

<sup>1</sup>**显著性水平**（通常用α表示）是你愿意接受的、在原假设实际为真时拒绝原假设的最高概率。常用的显著性水平为 0.05（或 5%）。

### 报告 > Rmd

通过点击屏幕左下角的<i title="report results" class="fa fa-edit"></i>图标或按键盘上的`ALT-enter`，向<a href="https://radiant-rstats.github.io/docs/data/report_rmd.html" target="_blank">*报告 > Rmd*</a>添加代码以（重新）创建分析。

如果已创建图表，可使用`ggplot2`命令进行自定义（例如，`plot(result, plots = "bar", custom = TRUE) + labs(title = "比例比较")`）。详情请参见<a href="https://radiant-rstats.github.io/docs/data/visualize.html" target="_blank">*数据 > 可视化*</a>。

### R 函数

有关 Radiant 中用于评估比例的相关 R 函数概述，请参见<a href =  "https://radiant-rstats.github.io/radiant.basics/reference/index.html#section-basics-proportions" target="_blank">*基础 > 比例*</a>。

`compare_props`工具中使用的来自`stats`包的核心函数是`prop.test`。

### 视频教程

将以下完整命令复制粘贴到 RStudio 控制台（即左下角窗口），按回车即可获取 Radiant 教程系列中假设检验模块使用的所有材料：

<pre>usethis::use_course("https://www.dropbox.com/sh/0xvhyolgcvox685/AADSppNSIocrJS-BqZXhD1Kna?dl=1")</pre>

<a href="https://youtu.be/ICqSRs4UfLM" target="_blank">比例比较假设检验</a>

- 本视频展示如何进行比例比较假设检验
- 主题列表：
  - 在 Radiant 中设置比例比较的假设检验
  - 使用 p 值和置信区间评估假设检验
