## urls for menu
r_url_list <- getOption("radiant.url.list")
r_url_list[["(Dis)similarity"]] <-
  list("tabs_mds" = list("Summary" = "multivariate/mds/", "Plot" = "multivariate/mds/plot/"))
r_url_list[["Attributes"]] <-
  list("tabs_prmap" = list("Summary" = "multivariate/prmap/", "Plot" = "multivariate/prmap/plot/"))
r_url_list[["Pre-factor"]] <-
  list("tabs_pre_factor" = list("Summary" = "multivariate/pfactor/", "Plot" = "multivariate/pfactor/plot/"))
r_url_list[["Factor"]] <-
  list("tabs_full_factor" = list("Summary" = "multivariate/factor/", "Plot" = "multivariate/factor/plot/"))
r_url_list[["Hierarchical clustering"]] <- "multivariate/hclus/"
r_url_list[["K-clustering"]] <-
  list("tabs_kclus" = list("Summary" = "multivariate/kclus/", "Plot" = "multivariate/kclus/plot/"))
r_url_list[["Conjoint"]] <-
  list("tabs_conjoint" = list(
    "Summary" = "multivariate/conjoint/",
    "Predict" = "multivariate/conjoint/predict/",
    "Plot" = "multivariate/conjoint/plot/"
  ))

options(radiant.url.list = r_url_list)
rm(r_url_list)

## design menu
options(
  radiant.multivariate_ui =
    tagList(
      navbarMenu(
        i18n$t("Multivariate"),
        tags$head(
          tags$script(src = "www_multivariate/js/store.js")
        ),
        i18n$t("Maps"),
        tabPanel(i18n$t("(Dis)similarity"), uiOutput("mds")),
        tabPanel(i18n$t("Attributes"), uiOutput("prmap")),
        "----", i18n$t("Factor"),
        tabPanel(i18n$t("Pre-factor"), uiOutput("pre_factor")),
        tabPanel(i18n$t("Factor"), uiOutput("full_factor")),
        "----", i18n$t("Cluster"),
        tabPanel(i18n$t("Hierarchical"), uiOutput("hclus")),
        tabPanel(i18n$t("K-clustering"), uiOutput("kclus")),
        "----", i18n$t("Conjoint"),
        tabPanel(i18n$t("Conjoint"), uiOutput("conjoint"))
      )
    )
)
