> 评估（二元）分类模型的性能

#### 响应变量（Response variable）

选择关注的结果变量或响应变量。该变量应为二元变量，可以是因子（factor）或仅有两个值的整数（即 0 和 1）。

#### 选择水平（Choose level）

响应变量中被视为 “成功事件” 的水平。例如，购买行为或购买者对应 “是（yes）”。

#### 预测变量（Predictor）

选择一个或多个可用于预测响应变量中所选水平的变量。可以是普通变量、RFM 指数，或模型的预测值（例如，通过 “模型> 逻辑回归（GLM）” 估计的逻辑回归模型，或通过 “模型 > 神经网络” 估计的神经网络模型的预测值）。

#### 分位数数量（# quantiles）

要创建的分箱数量。

#### 边际利润与成本（Margin & Cost）

若要使用 “利润（Profit）” 和 “营销支出回报率（ROME）” 图表，请输入每笔销售的 “边际利润（Margin）”  和估计的每次接触成本（Cost）（例如，邮寄成本或电子邮件 / 短信的机会成本）。例如，若一笔销售的边际利润为 10  美元（不含接触成本），接触成本为 1 美元，则在 “边际利润（Margin）” 和 “成本（Cost）” 输入框中分别输入 10 和 1。

#### 结果显示范围（Show results for）

如果启用了筛选器（例如，在 “数据> 查看” 标签页中设置），可选择为 “全部（All）” 数据、“训练（Training）” 数据、“测试（Test）” 数据，或 “训练和测试（Both）” 数据生成结果。若未启用筛选器，计算将应用于所有数据。

#### 图表（Plots）

生成提升图（Lift）、增益图（Gains）、利润图（Profit）和 / 或营销支出回报率图（ROME）。

### Report > Rmd

通过点击屏幕左下角的<i title="report results" class="fa fa-edit"></i>图标或按键盘上的`ALT-enter`，向<a href="https://radiant-rstats.github.io/docs/data/report_rmd.html" target="_blank">*Report > Rmd*</a>添加代码以（重新）创建分析。

如果在 “图表（Plots）” 标签页中创建了一组四个图表，可使用`patchwork`在图表组上方添加标题并设置两列布局，如下所示：

```r
plot(result, plots = c("lift", "gains", "profit", "rome"), custom = TRUE) %>%
  wrap_plots(plot_list, ncol = 2) + plot_annotation(title = "Model evaluation")
```

单个图表可使用`ggplot2`命令自定义（见下方示例）。详情请参见<a href="https://radiant-rstats.github.io/docs/data/visualize.html" target="_blank">*数据 > 可视化*</a>。

```r
plot(result, plots = "lift", custom = TRUE) +
  labs(caption = "Based on data from ...")
```

#### 混淆矩阵

通过 “预测变量（Predictor）” 选择的预测概率首先会使用 “边际利润（Margin）” 和 “成本（Cost）”  中输入的值转换为类别（例如，阳性或阴性结果）。当预测响应概率超过 “成本 / 边际利润（Cost / Margin）”  时，接触该客户是有利可图的。例如，若盈亏平衡响应率为 0.1，而预测响应概率为 0.25，则该客户将被标记为  “阳性（Positive）”。反之，若预测概率未超过盈亏平衡响应率，则客户将被标记为 “阴性（Negative）”。

将每个预测转换为类别标签（即阳性或阴性）后，会将结果与响应变量的实际值进行比较。生成的表格中为每个预测变量显示以下关键指标。

 标签（Label）                       | 描述（Description）                                          
------------------------ | ------------------------------------------------------------------
 TP（真阳性，True Positive）         | 阳性预测与数据中阳性结果一致的案例数量                       
 FP（假阳性，False Positive）        | 阳性预测但数据中结果为阴性的案例数量                         
 TN（真阴性，True Negative）         | 阴性预测与数据中阴性结果一致的案例数量                       
 FN（假阴性，False Negative）        | 阴性预测但数据中结果为阳性的案例数量                         
 total（总计）                       | 总案例数量（即 TP + FP + TN + FN）                           
 TPR（真阳性率，True Positive Rate） | 数据中阳性结果被正确预测为阳性的比例（即 TP / (TP + FN)），也称为敏感性（sensitivity）或召回率（recall） 
 TNR（真阴性率，True Negative Rate） | 数据中阴性结果被正确预测为阴性的比例（即 TN / (TN + FP)），也称为特异性（specificity） 
 precision（精确率）                 | 阳性预测中实际为阳性结果的比例（即 TP / (TP + FP)）          
 F-score（F 分数）                   | 精确率（precision）与真阳性率（TPR，敏感性）的调和平均数     
 accuracy（准确率）                  | 所有结果中被正确预测为阳性或阴性的比例（即 (TP + TN) /total） 
 kappa（Kappa 系数）                 | 对准确率指标的校正，消除纯随机情况下产生正确预测的概率影响   
 profit（利润）                      | 针对所有预测概率高于盈亏平衡响应率的客户进行营销所获得的总利润 
 index（指数）                       | 所选预测变量的相对盈利能力指数（最大值为 1）                 
 ROME（营销支出回报率）              | 针对所有预测概率高于盈亏平衡响应率的客户进行营销所实现的营销支出回报率 
 contact（接触比例）                 | 需接触的客户比例，即 (TP + FP) /total                        
 AUC（曲线下面积）                   | ROC 曲线下面积（AUC），ROC 即受试者工作特征（Receiver Operating Characteristic） 

### Report > Rmd (confusion)

通过点击屏幕左下角的<i title="report results" class="fa fa-edit"></i>图标或按键盘上的`ALT-enter`，向<a href="https://radiant-rstats.github.io/docs/data/report_rmd.html" target="_blank">*Report > Rmd*</a>添加代码以（重新）创建分析。

默认情况下仅绘制`kappa`、`index`、`ROME`和`AUC`。可通过 “报告> Rmd” 自定义绘制结果。例如，要更改绘图，可使用：

```r
plot(result, vars = c("precision", "profit", "AUC"))
```

图表可使用`ggplot2`命令进一步自定义（见下方示例）。详情请参见<a href="https://radiant-rstats.github.io/docs/data/visualize.html" target="_blank">*数据 > 可视化*</a>。

```r
plot(result, vars = c("precision", "profit", "AUC")) + 
  labs(caption = "Based on data from ...")
```

#### 下载选项（Download options）

要将表格下载为 csv 文件，点击屏幕右上角的下载按钮。要将图表下载为 png 文件，点击屏幕中右侧的下载图标。

## 示例

下方的提升图和增益图几乎没有显示过拟合迹象，表明针对约 65% 的客户进行营销可实现利润最大化。

<p align="center"><img src="figures_model/evalbin_lift_gains.png"></p>

<!-- 这一结论可通过混淆矩阵得到验证。训练样本和测试样本的真阳性率分别为94.0%和93.4%。

<p align="center"><img src="figures_model/evalbin_confusion.png"></p>
-->

上面截图中使用的预测值来自对`dvd`数据集的逻辑回归。该数据集可通过 “数据> 管理” 标签页获取（即从  “加载数据类型（Load data of type）” 下拉菜单中选择 “示例（Examples）”，然后点击 “加载（Load）”）。模型通过 “模型 > 逻辑回归（GLM）” 估计。下方显示的预测值在 “预测（Predict）” 标签页中生成。

<p align="center"><img src="figures_model/evalbin_logistic.png"></p>

### R 函数（R-functions）

有关 Radiant 中用于评估（二元）分类模型的相关 R 函数概述，请参见<a href =  "https://radiant-rstats.github.io/radiant.model/reference/index.html#section-model-evaluate-classification" target="_blank">*模型 > 分类模型评估*</a> 。