> 实验设计

## 示例

假设我们想使用三个因素测试不同的电影院设计方案。

- **价格（Price）**：10 美元、13 美元或 16 美元
- **视线（Sight）**：确定影院座位布局应为阶梯式还是非阶梯式
- **食物（Food）**：确定应提供热狗和爆米花、美食，还是不提供任何食物

## 最大水平数

纳入分析的因素分别有 3、2 和 3 个水平，因此我们在 “最大水平数（Max levels）” 输入框中输入`3`。

## 变量名和水平

这里我们输入感兴趣的因素。例如，输入`price`作为变量名，将 10 美元作为水平 1，13 美元作为水平 2，16 美元作为水平 3。然后点击<i title='Add factor'  class='fa fa-plus-circle'></i>图标。这会将所提供的因素信息以 Radiant  分析所需的格式添加到 “设计因素（Design factors）” 窗口中。要删除 “设计因素” 窗口中的最后一行，点击<i  title='Add factor' class='fa fa-minus-circle'></i>图标。

输入三个因素的必要信息后，屏幕应显示如下：

<p align="center"><img src="figures_design/doe_factors.png"></p>

## 创建设计

现在可以通过点击 “创建设计（Create design）” 按钮生成实验设计，将产生以下输出。

<p align="center"><img src="figures_design/doe_output.png"></p>

在我们的示例中，理想设计包含 18 次试验。然而，这意味着部分因子设计和完全因子设计的规模相同。我们想知道是否可以减少试验次数，详见下方的 “试验次数（# trials）” 部分。

## 试验次数

该输入可用于控制生成的试验次数。如果留空，Radiant 将尝试使用<a  href="https://cran.r-project.org/web/packages/AlgDesign/index.html"  target="_blank">AlgDesign</a>包中的`optFederov`函数找到合适的试验次数。

让我们查看 “设计效率（Design efficiency）” 中的输出。在我们的示例中，目标是找到一个试验次数少于 18  次的设计，且该设计仍能让我们估计感兴趣的效应（例如，不同价格、视线和食物水平的主效应）。注意，有几个设计被认为是  “平衡的（balanced）”（即每个水平包含在相同数量的试验中）。我们要寻找一个平衡且因素间相关性最小的设计（例如，D 效率评分高于  0.8）。可以将 D 效率评分视为运行测试 / 实验后，我们能多清晰地估计感兴趣效应的度量。理想的 D 效率评分为 1，但高于 0.8  的评分被认为是合理的。

具有平衡设计的最小试验次数是 6 次。该设计之所以平衡，只是因为 6 能被 3 和 2（即我们因素的水平数）整除。然而，其 D  效率评分相当低（0.513）。下一个最小的平衡设计有 12 次试验，且具有高得多的 D  效率。如果我们想估计每个因素水平对电影院选择或偏好的主效应，这个设计是合理的选择。

要生成所需的部分因子设计，在 “试验次数（# trials）” 输入框中输入`12`，然后按 “创建设计（Create design）”，将产生以下输出。

<p align="center"><img src="figures_design/doe_output_partial.png"></p>

输出中的 “试验（trial）” 列显示了从完全因子设计中选择的轮廓。请注意，只有当 D 效率等于 1  时，部分因子设计的（多系列）相关矩阵的非对角线元素才都会等于 0。<a  href="https://cran.r-project.org/web/packages/polycor/index.html"  target="_blank">polycor</a>包用于估计因素间的相关性。

## 随机种子

部分因子设计可能不是唯一的（即可能存在多个同样好的试验或轮廓组合）。通过设置随机种子，每次点击 “创建设计” 时，都会生成相同的试验集。然而，要查看其他部分因子设计，清空 “随机种子（Rnd. seed）” 框并多次点击  “创建设计”，观察所选试验集的变化。

## 交互作用

请注意，如果我们使用包含 12 次试验的设计，将无法估计`price`、`sight`和`food`之间所有可能的交互作用。这是部分因子设计固有的权衡！事实上，如果我们确实想估计哪怕一个交互作用（例如，选择`price:sight`），合适的设计需要 18 次试验（即包含所有可能因素水平组合的完全因子设计的试验次数）。

## 部分因子和完全因子设计

点击 “部分（Partial）” 或 “完全（Full）” 按钮，以 csv 格式下载部分因子或完全因子设计。

## 上传和下载

要下载输入的因素列表，点击 “下载（Download）” 按钮。要上传先前创建的因素集，点击 “上传（Upload）” 按钮并浏览找到所需文件。

### 报告 > Rmd

通过点击屏幕左下角的<i title="report results" class="fa fa-edit"></i>图标或按键盘上的`ALT-enter`，向<a href="https://radiant-rstats.github.io/docs/data/report_rmd.html" target="_blank">*报告 > Rmd*</a>添加代码以（重新）创建设计。

### R 函数

有关 Radiant 中用于实验设计的相关 R 函数概述，请参见<a href =  "https://radiant-rstats.github.io/radiant.design/reference/index.html#section-design-design-of-experiments-doe-" target="_blank">*设计 > 实验设计*</a>。

`doe`工具中使用的来自`AlgDesign`包的核心函数是`optFederov`。
