> 比较数据中两个或多个变量或组的均值

均值比较 t 检验用于比较一个组中某个变量的均值与一个或多个其他组中同一变量的均值。总体中组间差异的原假设设为零。我们使用样本数据检验这一假设。

我们可以执行单侧检验（即`小于`或`大于`）或双侧检验（见 “备择假设（Alternative hypothesis）” 下拉菜单）。单侧检验用于评估现有数据是否提供证据表明组间样本均值差异小于（或大于）零。

### 示例：教授薪资

我们获取了美国某学院助理教授、副教授和教授的 9 个月学术薪资数据（2008-09 学年）。这些数据是学院行政部门为监测男女教师薪资差异而持续收集的一部分。数据包含 397 个观测值和以下 6 个变量：

- `rank` = 因子，水平为 AsstProf（助理教授）、AssocProf（副教授）、Prof（教授）
- `discipline` = 因子，水平为 A（“理论型” 院系）或 B（“应用型” 院系）
- `yrs.since.phd` = 获得博士学位后的年数
- `yrs.service` = 任职年数
- `sex` = 因子，水平为 Female（女性）和 Male（男性）
- `salary` = 9 个月薪资（美元）

这些数据来自 CAR 包，与以下书籍相关：Fox J. 和 Weisberg, S. (2011)《应用回归的 R 伴侣（第二版）》，Sage 出版社。

假设我们要检验职级较低的教授是否比职级较高的教授薪资更低。为检验这一假设，我们首先选择教授`rank`，并选择`salary`作为要在不同职级间比较的数值变量。在 “选择组合（Choose combinations）” 框中选择所有可用条目，对三个职级进行两两比较。注意，移除所有条目会自动选择所有组合。我们关注单侧假设（即`小于`）。

<p align="center"><img src="figures_basics/compare_means_summary.png"></p>

输出的前两个区块显示检验的基本信息（如所选变量和置信水平）和汇总统计量（如每组的均值、标准差、误差边际等）。最后一个区块显示以下内容：

* `Null hyp.`是原假设，`Alt. hyp.`是备择假设
* `diff`是两组样本均值的差异（例如，80775.99 - 93876.44 = -13100.45）。如果原假设为真，我们预期这一差异较小（即接近零）
* `p.value`是在原假设为真时，找到与`diff`一样极端或更极端值的概率

如果勾选 “显示额外统计量（Show additional statistics）”，会添加以下输出：

<pre>
Pairwise mean comparisons (t-test)
Data      : salary 
Variables : rank, salary 
Samples   : independent 
Confidence: 0.95 
Adjustment: None 

      rank        mean   n n_missing         sd        se        me
  AsstProf  80,775.985  67         0  8,174.113   998.627 1,993.823
 AssocProf  93,876.438  64         0 13,831.700 1,728.962 3,455.056
      Prof 126,772.109 266         0 27,718.675 1,699.541 3,346.322

 Null hyp.              Alt. hyp.              diff      p.value se       t.value df      0%   95%           
 AsstProf = AssocProf   AsstProf < AssocProf   -13100.45 < .001  1996.639  -6.561 101.286 -Inf  -9785.958 ***
 AsstProf = Prof        AsstProf < Prof        -45996.12 < .001  1971.217 -23.334 324.340 -Inf -42744.474 ***
 AssocProf = Prof       AssocProf < Prof       -32895.67 < .001  2424.407 -13.569 199.325 -Inf -28889.256 ***

Signif. codes:  0 '***' 0.001 '**' 0.01 '*' 0.05 '.' 0.1 ' ' 1
</pre>

* `se`是标准误（即`diff`抽样分布的标准差）
* `t.value`是与`diff`相关的 t 统计量，可与 t 分布比较（即`diff` / `se`）
* `df`是统计检验的自由度。注意，自由度使用 Welch 近似法计算
* `0% 95%`显示样本均值差异的 95% 置信区间。这些数值提供了真实总体差异可能落入的范围

### 检验方法

我们可以使用三种方法评估原假设。我们选择显著性水平为 0.05。<sup>1</sup> 当然，每种方法会得出相同结论。

#### p 值

由于每个 p 值都**小于**显著性水平，我们拒绝每个评估的教授职级对的原假设。数据表明，副教授薪资高于助理教授，教授薪资高于助理教授和副教授。注意，“***” 用作显著性指标。

#### 置信区间

由于任何置信区间都**不**包含零，我们拒绝每个评估的职级组合的原假设。由于我们的备择假设是`小于`，置信区间实际上是总体薪资差异的 95% 置信上限（即 - 9785.958、-42744.474 和 - 28889.256）。

#### t 值

由于计算的 t 值（-6.561、-23.334 和 - 13.569）**小于**相应的临界 t 值，我们拒绝每个评估的职级组合的原假设。可通过 “基础（Basics）” 菜单中的概率计算器获取临界 t 值。以助理教授与副教授的检验为例，我们发现对于自由度为 101.286 的 t 分布（见`df`），临界 t 值为 1.66。由于备择假设是`小于`，我们选择 0.05 作为下侧概率界。

<p align="center"><img src="figures_basics/compare_means_prob_calc.png"></p>

除 “摘要（Summary）” 标签页中的数值输出外，我们还可以可视化研究`rank`与`salary`之间的关联（见 “绘图（Plot）” 标签页）。下方截图显示教授薪资的散点图和带有置信区间（黑色）与标准误（蓝色）条的条形图。与 “摘要” 标签页中的结果一致，不同职级的薪资存在明显差异。我们也可以选择将样本数据绘制成箱线图或密度曲线图。

<p align="center"><img src="figures_basics/compare_means_plot.png"></p>

### 多重比较调整

我们评估的比较越多，即使原假设为真，仅因随机因素而发现 “显著” 结果的可能性就越大。如果我们进行 100 次检验，并将**显著性水平**设为 0.05（或 5%），即使总体中不存在关联，我们也可能预期有 5 个 p 值小于或等于 0.05。

Bonferroni 调整确保 p 值根据所进行的检验数量适当缩放。<a href="https://xkcd.com/882/" target="blank">这幅 XKCD 漫画</a>清晰地说明了这类调整的必要性。

### 统计术语

这是**均值比较**检验，原假设为真实总体**均值差异**等于**0**。使用 0.05 的显著性水平，我们拒绝每个评估的职级对的原假设，并得出结论：真实总体**均值差异小于**0。

助理教授与副教授薪资差异检验的 p 值为 **< .001**。这是在原假设为真时，观察到与数据中样本**均值差异**一样极端或更极端的样本**均值差异**的概率。在本例中，它是当真实总体**均值差异**为**0**时，观察到样本**均值差异**小于（或等于）**-13100.45**的概率。

95% 置信界为 **-9785.958**。如果重复抽样并为每个样本计算 95% 置信界，真实总体均值将在 95% 的样本中低于该下界。

<sup>1</sup>**显著性水平**（通常用α表示）是你愿意接受的、在原假设实际为真时拒绝原假设的最高概率。常用的显著性水平为 0.05（或 5%）。

### 报告 > Rmd

通过点击屏幕左下角的<i title="report results" class="fa fa-edit"></i>图标或按键盘上的`ALT-enter`，向<a href="https://radiant-rstats.github.io/docs/data/report_rmd.html" target="_blank">*报告 > Rmd*</a>添加代码以（重新）创建分析。

如果已创建图表，可使用`ggplot2`命令进行自定义（例如，`plot(result, plots = "scatter", custom = TRUE) + labs(title = "均值比较")`）。详情请参见<a href="https://radiant-rstats.github.io/docs/data/visualize.html" target="_blank">*数据 > 可视化*</a>。

### R 函数

有关 Radiant 中用于评估均值的相关 R 函数概述，请参见<a href =  "https://radiant-rstats.github.io/radiant.basics/reference/index.html#section-basics-means" target="_blank">*基础 > 均值*</a>。

`compare_means`工具中使用的来自`stats`包的核心函数是`t.test`。

### 视频教程

将以下完整命令复制粘贴到 RStudio 控制台（即左下角窗口），按回车即可获取 Radiant 教程系列中假设检验模块使用的所有材料：

<pre>usethis::use_course("https://www.dropbox.com/sh/0xvhyolgcvox685/AADSppNSIocrJS-BqZXhD1Kna?dl=1")</pre>

<a href="https://youtu.be/cTWk0JADnVg" target="_blank">均值比较假设检验</a>

- 本视频展示如何进行均值比较假设检验
- 主题列表：
  - 按组计算汇总统计量
  - 在 Radiant 中设置均值比较的假设检验
  - 使用 p 值和置信区间评估假设检验
