library(shiny.i18n)
# file with translations
i18n <- Translator$new(translation_csvs_path = "../translations")

# change this to zh
i18n$set_translation_language("zh")

## sourcing from radiant.data
options(radiant.path.data = system.file(package = "radiant.data"))
source(file.path(getOption("radiant.path.data"), "app/global.R"), encoding = getOption("radiant.encoding", default = "UTF-8"), local = TRUE)

ifelse(grepl("radiant.basics", getwd()) && file.exists("../../inst"), "..", system.file(package = "radiant.basics")) %>%
  options(radiant.path.basics = .)

## setting path for figures in help files
addResourcePath("figures_basics", "tools/help/figures/")

## setting path for www resources
addResourcePath("www_basics", file.path(getOption("radiant.path.basics"), "app/www/"))

## loading urls and ui
source("init.R", encoding = getOption("radiant.encoding", "UTF-8"), local = TRUE)
options(radiant.url.patterns = make_url_patterns())

## if radiant.data is not in search main function from dplyr etc. won't be available
if (!"package:radiant.basics" %in% search() &&
    isTRUE(getOption("radiant.development")) &&
    getOption("radiant.path.basics") == "..") {
  options(radiant.from.package = FALSE)
} else {
  options(radiant.from.package = TRUE)
}
