> 以交互式表格显示数据

### 数据集

从 `数据集` 下拉菜单中选择一个数据集。文件通过`数据 > 管理` 标签加载到 Radiant 中。

### 过滤数据

有多种方法可选择数据子集进行查看。左侧的 `过滤数据` 框（点击复选框）可与`>`和`<`等符号配合使用。你也可以组合子集命令，例如，`x > 3 & y == 2`将只显示变量`x`的值大于 3**且**变量`y`等于 2 的行。注意，在 R 和大多数其他编程语言中，`=`用于**赋值**，`==`用于判断值是否**相等**。相反，`!=`用于判断两个值是否**不相等**。你还可以使用包含**或（OR）** 条件的表达式。例如，要选择 “Salary” 小于 100,000 美元**或**大于 20,000 美元的行，使用`Salary > 20000 | Salary < 100000`。`|`是**或（OR）** 的符号，`&`是**且（AND）** 的符号。

也可以使用日期进行过滤。例如，要选择 2014 年 6 月 1 日之前的行，在过滤框中输入`date < "2014-6-1"`并按回车。

你还可以使用字符串匹配选择行。例如，输入`grepl('ood', cut)`可选择`cut`为 “Good” 或 “Very good” 的行。默认情况下，此搜索区分大小写。如需不区分大小写的搜索，使用`grepl("GOOD", cut, ignore.case = TRUE)`。在 `过滤` 框中输入语句并按回车，屏幕上会显示结果；如果表达式无效，框下方会显示错误信息。

重要的是，这些过滤器是**持久的**，将应用于 Radiant 中的所有分析。要停用过滤器，取消勾选 `过滤数据` 复选框。要移除过滤器，直接删除即可。


<table class='table table-condensed table-hover' style='width:60%;'>
 <thead>
  <tr>
   <th style="text-align:left;"> Operator </th>
   <th style="text-align:left;"> Description </th>
   <th style="text-align:left;"> Example </th>
  </tr>
 </thead>
<tbody>
  <tr>
   <td style="text-align:left;"> `<` </td>
   <td style="text-align:left;"> less than </td>
   <td style="text-align:left;"> `price < 5000` </td>
  </tr>
  <tr>
   <td style="text-align:left;"> `<=` </td>
   <td style="text-align:left;"> less than or equal to </td>
   <td style="text-align:left;"> `carat <= 2` </td>
  </tr>
  <tr>
   <td style="text-align:left;"> `>` </td>
   <td style="text-align:left;"> greater than </td>
   <td style="text-align:left;"> `price > 1000` </td>
  </tr>
  <tr>
   <td style="text-align:left;"> `>=` </td>
   <td style="text-align:left;"> greater than or equal to </td>
   <td style="text-align:left;"> `carat >= 2` </td>
  </tr>
  <tr>
   <td style="text-align:left;"> `==` </td>
   <td style="text-align:left;"> exactly equal to </td>
   <td style="text-align:left;"> `cut == 'Fair'` </td>
  </tr>
  <tr>
   <td style="text-align:left;"> `!=` </td>
   <td style="text-align:left;"> not equal to </td>
   <td style="text-align:left;"> `cut != 'Fair'` </td>
  </tr>
  <tr>
   <td style="text-align:left;"> `|` </td>
   <td style="text-align:left;"> x OR y </td>
   <td style="text-align:left;"> `price > 10000 | cut == 'Premium'` </td>
  </tr>
  <tr>
   <td style="text-align:left;"> `&` </td>
   <td style="text-align:left;"> x AND y </td>
   <td style="text-align:left;"> `carat < 2 & cut == 'Fair'` </td>
  </tr>
  <tr>
   <td style="text-align:left;"> `%in%` </td>
   <td style="text-align:left;"> x is one of y </td>
   <td style="text-align:left;"> `cut %in% c('Fair', 'Good')` </td>
  </tr>
  <tr>
   <td style="text-align:left;"> is.na </td>
   <td style="text-align:left;"> is missing </td>
   <td style="text-align:left;"> `is.na(price)` </td>
  </tr>
</tbody>
</table>

过滤器也可与 R 代码结合使用，快速查看所选数据集的样本。例如，`runif(n()) > .9`可用于抽样数据中约 10% 的行，`1:n() < 101`将只选择数据的前 100 行。

### 选择要显示的变量

默认情况下，会显示数据中的所有列。点击任意变量可单独聚焦该变量。要选择多个变量，使用键盘上的 SHIFT 键和箭头键。在 Mac 上，可使用 CMD 键选择多个变量；在 Windows 上，使用 CTRL  键可达到相同效果。要选择所有变量，使用 CTRL-A（Mac 上为 CMD-A）。

### 浏览数据

默认情况下，一次仅显示 10 行数据。你可以通过 “显示…… 条目（Show ... entries）” 下拉菜单更改此设置。点击屏幕右下角的 “下一页（Next）” 和 “上一页（Previous）” 按钮翻阅数据。

### 排序

点击表格中的列标题可对数据排序。再次点击将在升序和降序排序之间切换。要同时按多列排序，按住 Shift 键，然后点击第 2 列、第 3 列等进行排序。

### 列过滤和搜索

对于具有有限个不同值的变量（即因子），你可以从变量名下的列过滤器中选择要保留的水平。例如，要过滤出切工为理想（Ideal）的行，点击`cut`列标题下方的框，从显示的下拉菜单中选择`Ideal`。你也可以在这些列过滤器中输入字符串，然后按回车。注意，匹配不区分大小写。实际上，输入`eal`也会得到相同结果，因为搜索会匹配字符串的任意部分。同样，你可以输入字符串来基于字符变量（如街道名称）选择行。

对于数值变量，列过滤器框有一些特殊功能，使其几乎与 `过滤数据` 框一样强大。对于数值和整数变量，你可以使用`...`表示范围。例如，要选择价格在 500 美元到 2000 美元之间的`price`值，输入`500 ... 2000`并按回车。该范围包含输入的值。此外，如果我们想过滤`carat`，`0.32 ...`将只显示克拉值大于或等于 0.32 的钻石。数值变量还有一个滑块，可用于定义要保留的值的范围。

如果你想更高级地操作，可以使用右上角的搜索框，通过**正则表达式**搜索所有列。例如，要查找**任何**列中条目以数字 72 结尾的所有行，输入`72$`（即`$`符号用于表示条目的结尾）。要查找所有条目以 60 开头的行，使用`^60`（即`^`用于表示条目的第一个字符）。正则表达式的搜索功能非常强大，但这是一个较广的主题。要了解更多关于正则表达式的内容，参见此<a href="http://www.regular-expressions.info/tutorial.html"  target="_blank">教程</a>。

### 存储过滤器

重要的是，列排序、列过滤器和搜索**不具有持久性**。要将这些设置存储用于 Radiant 的其他部分，按 “存储（Store）” 按钮。你可以通过更改 `存储`  按钮左侧文本输入框中的值，将数据和设置存储在不同的数据集名称下。此功能也可用于选择要保留的变量子集：只需选择你想保留的变量，然后按  `存储` 按钮。要更精确地控制要保留或移除的变量，并指定它们在数据集中的顺序，请使用 “数据 > 转换” 标签。

要以 csv 格式下载数据，点击屏幕右上角的<i title='Download' class='fa fa-download'></i>图标。

点击屏幕左下角的报告（<i title='Report results' class='fa fa-edit'></i>）图标，或按键盘上的`ALT-enter`，将 Radiant 使用的过滤和排序命令添加到<a  href="https://radiant-rstats.github.io/docs/data/report_rmd.html"  target="_blank">“报告> Rmd”</a>中的（可重复的）报告中。

### R 函数

有关 Radiant 中用于查看、搜索和过滤数据的相关 R 函数概述，请参见<a href = "  https://radiant-rstats.github.io/radiant.data/reference/index.html#section-data-view" target="_blank">“数据> 查看”</a> 。
