% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conjoint.R
\name{predict.conjoint}
\alias{predict.conjoint}
\title{Predict method for the conjoint function}
\usage{
\method{predict}{conjoint}(
  object,
  pred_data = NULL,
  pred_cmd = "",
  conf_lev = 0.95,
  se = FALSE,
  interval = "confidence",
  dec = 3,
  envir = parent.frame(),
  ...
)
}
\arguments{
\item{object}{Return value from \code{\link{conjoint}}}

\item{pred_data}{Provide the dataframe to generate predictions. The dataset must contain all columns used in the estimation}

\item{pred_cmd}{Command used to generate data for prediction}

\item{conf_lev}{Confidence level used to estimate confidence intervals (.95 is the default)}

\item{se}{Logical that indicates if prediction standard errors should be calculated (default = FALSE)}

\item{interval}{Type of interval calculation ("confidence" or "prediction"). Set to "none" if se is FALSE}

\item{dec}{Number of decimals to show}

\item{envir}{Environment to extract data from}

\item{...}{further arguments passed to or from other methods}
}
\description{
Predict method for the conjoint function
}
\details{
See \url{https://radiant-rstats.github.io/docs/multivariate/conjoint.html} for an example in Radiant
}
\examples{
result <- conjoint(mp3, rvar = "Rating", evar = "Memory:Shape")
predict(result, pred_data = mp3)

}
\seealso{
\code{\link{conjoint}} to generate the result

\code{\link{summary.conjoint}} to summarize results

\code{\link{plot.conjoint}} to plot results
}
