import { getMessage } from "@/api/user"

export default {
  data() {
    return {
      messageCount: 0,
      messageList: [],
      loading: false,
      pageNum: 1,
      pageSize: 6,
    }
  },
  methods: {
    getMessage() {
      this.loading = true
      getMessage({
        pageSize: this.pageSize,
        pageNum: this.pageNum,
        patientFrom: this.curSelectedIndex,
      }).then((res) => {
        if (res.code == 1) {
          this.messageCount = res.data.total
          this.messageList = [...this.messageList, ...res.data.records]
          // console.log(res.data.total)
        } else {
          this.messageCount = 0
        }
        this.loading = false
      })
    },
  },
}
