/**
 * @copyright chuzhixin 1204505056@qq.com
 * @description 登录、获取用户信息、退出登录、清除accessToken逻辑，不建议修改
 */

import Vue from "vue"
import { login, getUserCurrent, logout, getFeedBackNumber } from "@/api/user"
import {
  getAccessToken,
  removeAccessToken,
  setAccessToken,
} from "@/utils/accessToken"
import { resetRouter } from "@/router"
import { tokenName } from "@/config/settings"

const state = {
  accessToken: getAccessToken(),
  userInfo: null,
  roles: [],
  menuList: [],
  group: "",
  feedBackNumber: 0,
  getMessageFlag: false,
}
const getters = {
  accessToken: (state) => state.accessToken,
  userInfo: (state) => state.userInfo,
  group: (state) => state.group,
  roles: (state) => state.roles,
  menuList: (state) => state.menuList,
  feedBackNumber: (state) => state.feedBackNumber,
  getMessageFlag: (state) => state.getMessageFlag,
}
const mutations = {
  setGetMessageFlag(state, MessageFlag) {
    state.getMessageFlag = MessageFlag
  },
  setAccessToken(state, accessToken) {
    state.accessToken = accessToken
    setAccessToken(accessToken)
  },
  setUserInfo(state, userInfo) {
    localStorage.setItem("userInfo", JSON.stringify(userInfo))
    state.userInfo = userInfo
  },
  setGroup(state, group) {
    state.group = group
  },
  setRoles(state, roles) {
    state.roles = roles
  },
  setMenuList(state, menuList) {
    state.menuList = menuList
  },
  setFeedBackNumber(state, feedBackNumber) {
    state.feedBackNumber = feedBackNumber
  },
}
const actions = {
  async login({ commit }, userInfo) {
    const data = await login(userInfo)
    const accessToken = data[tokenName]
    if (accessToken) {
      commit("setAccessToken", accessToken)
      const hour = new Date().getHours()
      const thisTime =
        hour < 8
          ? "早上好"
          : hour <= 11
          ? "上午好"
          : hour <= 13
          ? "中午好"
          : hour < 18
          ? "下午好"
          : "晚上好"
    } else {
      Vue.prototype.$baseMessage(
        `登录接口异常，未正确返回${tokenName}...`,
        "error"
      )
    }
  },
  async getInfo({ commit, state, dispatch }) {
    const { data } = await getUserCurrent()
    if (!data) {
      Vue.prototype.$baseMessage("验证失败，请重新登录...", "error")
      return false
    }
    let { menuList, user, roleList, group } = data
    if (menuList && user) {
      // dispatch("getFeedBackNumber", user.id)
      commit("setMenuList", menuList)
      commit("setUserInfo", user)
      commit("setRoles", roleList)
      commit("setGroup", group)
      return menuList
    } else {
      Vue.prototype.$baseMessage("获取用户信息接口异常", "error")
      return false
    }
  },
  async getFeedBackNumber({ commit }, id) {
    const { data } = await getFeedBackNumber(id)
    commit("setFeedBackNumber", data)
  },
  async logout({ dispatch }) {
    await logout()
    await dispatch("tagsBar/delAllRoutes", null, {
      root: true,
    })
    await dispatch("resetAccessToken")
    await resetRouter()
  },
  resetAccessToken({ commit }) {
    commit("setMenuList", [])
    commit("setUserInfo", "")
    commit("setAccessToken", "")
    commit("setGroup", "")
    commit(
      "dict/setDictData",
      {},
      {
        root: true,
      }
    )
    removeAccessToken()
  },
}
export default {
  state,
  getters,
  mutations,
  actions,
}
