import { getDictDetailList, getDictList } from "@/api/dict.js"
import { Local } from "@/utils/storage"
import { translateListToTree } from "@/utils/handleRoutes.js"

const state = {
  dictSet: Local.get("dictSet") || [],
  dictMap: Local.get("dictMap") || {},
}
const getters = {
  dictSet: (state) => state.dictSet,
  dictMap: (state) => state.dictMap,
}
const mutations = {
  setDictSet(state, data) {
    state.dictSet = data
    Local.set("dictSet", data)
  },
  setDictData(state, data) {
    state.dictMap = data
    Local.set("dictMap", data)
  },
}
const actions = {
  async getDictData({ commit, state }) {
    let dictSet = state.dictSet
    const dictMap = state.dictMap
    const { data: latestDict } = await getDictList()
    const latestDictSet = latestDict.map((_) => _.type)
    let newDictSet = []
    latestDict.forEach((v) => {
      if (!dictSet.find((_) => _.type === v.type)) {
        newDictSet.push(v.type)
      }
    })
    commit("setDictSet", latestDict)
    newDictSet = Object.keys(dictMap).length === 0 ? latestDictSet : newDictSet
    // 存在新增加的字典
    if (newDictSet.length > 0) {
      const originalDictMap = Object.assign({}, dictMap)
      getDictDetailList(newDictSet).then((res) => {
        const d = res.data
        Object.keys(d).forEach((key) => {
          const list = d[key].map((item) => {
            return {
              label: item.name,
              value: item.code,
              id: item.id,
              parentId: item.parentId,
            }
          })
          originalDictMap[key] = translateListToTree(list)
        })
        commit("setDictData", originalDictMap)
      })
    }
  },
  // 更新字典分类
  async updateDictType({ commit, state }, data) {
    console.log('执行updateDictType')
    commit("setDictSet", data)
  },
  // 更新字典详情
  async updateDictDetail({ commit, state }, { type, data }) {
    console.log('执行updateDictDetail')
    const dictMap = state.dictMap
    if (type) {
      const list = data.map((item) => {
        return {
          label: item.name,
          value: item.code,
          id: item.id,
          parentId: item.parentId,
        }
      })
      dictMap[type] = translateListToTree(list)
      commit("setDictData", dictMap)
    }
  },
}
export default {
  state,
  getters,
  mutations,
  actions,
}
