import request from "@/utils/request"

/* 机构管理 */

export function getOrgPage(params = {}) {
  return request({
    url: "/cloud-upms/org/page",
    method: "get",
    params,
  })
}

export function getOrgList(params = {}) {
  return request({
    url: "/cloud-upms/org/list",
    method: "get",
    params,
  })
}

export function delOrg(id) {
  return request({
    url: `/cloud-upms/org/${id}`,
    method: "delete",
  })
}

export function addOrg(data = {}) {
  return request({
    url: "/cloud-upms/org",
    method: "post",
    data,
  })
}

/* 科室管理 */

export function getDepartPage(params = {}) {
  return request({
    url: "/cloud-upms/sys/org/department/page",
    method: "get",
    params,
  })
}
export function delDepart(id) {
  return request({
    url: `/cloud-upms/sys/org/department/${id}`,
    method: "delete",
  })
}

export function addDepart(data = {}) {
  return request({
    url: "/cloud-upms/sys/org/department",
    method: "post",
    data,
  })
}
