import request from "@/utils/request"

/* 数据库管理 */

export function addArticle(data = {}) {
  return request({
    url: "/cloud-upms/sys/article/addOrUpdate",
    method: "post",
    data,
  })
}
// 获取列表
export function articleList(params = {}) {
  return request({
    url: "/cloud-upms/sys/article/list",
    method: "get",
    params,
  })
}
// 启用禁用状态
export function articleEnable(params = {}) {
  return request({
    url: "/cloud-upms/sys/article/enable",
    method: "get",
    params,
  })
}
// 删除文章
export function deleteArticle(id) {
  return request({
    url: `/cloud-upms/sys/article/${id}`,
    method: "delete",
  })
}
