import request from "@/utils/request"

/**
 * 字段配置
 *
 *  */

export function getFieldPage(params = {}) {
  return request({
    url: "/cloud-upms/field/dict/page",
    method: "get",
    params,
  })
}

export function delField(id) {
  return request({
    url: `/cloud-upms/field/dict/${id}`,
    method: "delete",
  })
}

export function addField(data = {}) {
  return request({
    url: "/cloud-upms/field/dict",
    method: "post",
    data,
  })
}

// 根据表code查询list
export function getFieldListByCode(params = {}) {
  return request({
    url: "/cloud-upms/field/dict/list/table",
    method: "get",
    params,
  })
}

/**
 * 表单配置
 *
 *  */

export function getFormPage(params = {}) {
  return request({
    url: "/cloud-upms/org/form/page",
    method: "get",
    params,
  })
}

export function getFormList(params = {}) {
  return request({
    url: "/cloud-upms/org/form/list",
    method: "get",
    params,
  })
}

export function delForm(id) {
  return request({
    url: `/cloud-upms/org/form/${id}`,
    method: "delete",
  })
}

export function addForm(data = {}) {
  return request({
    url: "/cloud-upms/org/form",
    method: "post",
    data,
  })
}

// 复制配置表单
export function copyForm(data = {}) {
  return request({
    url: "/cloud-upms/org/form/copy",
    method: "post",
    data,
  })
}

// 获取
export function getFormDetail(id) {
  return request({
    url: `/cloud-upms/org/form/${id}`,
    method: "get",
  })
}

// 历史记录分页
export function getFormHistoryPage(params = {}) {
  return request({
    url: "/cloud-upms/form/history/page",
    method: "get",
    params,
  })
}

// 表单回滚
export function rollbackForm(historyId) {
  return request({
    url: `/cloud-upms/form/history/rollback?historyId=${historyId}`,
    method: "post",
  })
}
// 历史记录详情

export function getHistoryInfo(historyId) {
  return request({
    url: `/cloud-upms/form/history/info?historyId=${historyId}`,
    method: "get",
  })
}

/* 字段映射 */

// 分页
export function getFeignFieldPage(params) {
  return request({
    url: `/cloud-upms/feign/field/page`,
    method: "get",
    params,
  })
}

// 新增/修改
export function feignField(data = {}) {
  return request({
    url: "/cloud-upms/feign/field",
    method: "post",
    data,
  })
}
// 删除
export function delFeignField(id) {
  return request({
    url: `/cloud-upms/feign/field?id=${id}`,
    method: "delete",
  })
}

// 根据表单id查询 目标表list
export function getGroupFormTableList(params) {
  return request({
    url: `/cloud-upms/org/form/table/list`,
    method: "get",
    params,
  })
}
