import request from "@/utils/request"

/*
  字典分类表

*/

// 查询 list
export function getDictList(params) {
  return request({
    url: `/cloud-upms/dict/type/list`,
    method: "get",
    params,
  })
}

// 新增字典分类表
export function updateDictType(data) {
  return request({
    url: `/cloud-upms/dict/type`,
    method: "post",
    data,
  })
}

// 删除字典分类表
export function delDictType(id) {
  return request({
    url: `/cloud-upms/dict/type/${id}`,
    method: "delete",
  })
}

/*
 字典数据
*/

/*
  查询 字典list
* @param typeList
*/
// 批量查询
export function getDictDetailList(data) {
  return request({
    url: `/cloud-upms/dict/batch/type`,
    method: "post",
    data,
  })
}

// 查询 list 根据type
export function getDictDetail(params) {
  return request({
    url: `/cloud-upms/dict/type`,
    method: "get",
    params,
  })
}

// 新增字典
export function addDictDetail(data) {
  return request({
    url: `/cloud-upms/dict`,
    method: "post",
    data,
  })
}
// 删除字典表
export function delDictDetail(id) {
  return request({
    url: `/cloud-upms/dict/${id}`,
    method: "delete",
  })
}
