import request from "@/utils/request"
import { add } from "lodash"

/* 数据库管理 */

export function getDbPage(params = {}) {
  return request({
    url: "/cloud-upms/sys/db/info/page",
    method: "get",
    params,
  })
}

export function getDbList(params = {}) {
  return request({
    url: "/cloud-upms/sys/db/info/list",
    method: "get",
    params,
  })
}

export function addDb(data = {}) {
  return request({
    url: "/cloud-upms/sys/db/info",
    method: "post",
    data,
  })
}

// 测试连接
export function testDb(data = {}) {
  return request({
    url: "/cloud-upms/sys/db/info/test/connection",
    method: "post",
    data,
  })
}

// 根据数据库id 查数据表

export function getTableList(id) {
  return request({
    url: `/cloud-upms/sys/table/list?dbId=${id}`,
    method: "get",
  })
}

// 新增数据表
export function addDbTable(data = {}) {
  return request({
    url: "/cloud-upms/sys/table",
    method: "post",
    data,
  })
}
