import request from "@/utils/request"

/*
  协作组管理

*/

// 查询 list
export function getCoopGroupList(params) {
  return request({
    url: `/cloud-upms/coop/group/list`,
    method: "get",
    params,
  })
}

// 新增 协作组
export function addCoopGroup(data) {
  return request({
    url: `/cloud-upms/coop/group`,
    method: "post",
    data,
  })
}

// 删除协作组
export function delCoopGroup(id) {
  return request({
    url: `/cloud-upms/sys/sdd/manage/${id}`,
    method: "delete",
  })
}

/*
  协作组用户管理

*/

// 查询 page
export function getGroupUserPage(params) {
  return request({
    url: `/cloud-upms/coop/group/user/page`,
    method: "get",
    params,
  })
}

// 新增 协作组用户
export function addGroupUser(data) {
  return request({
    url: `/cloud-upms/coop/group/user`,
    method: "post",
    data,
  })
}

// 删除协作组用户
export function delGroupUser(id) {
  return request({
    url: `/cloud-upms/coop/group/user/${id}`,
    method: "delete",
  })
}

/*
  协作组表单管理

*/

// 查询 page
export function getGroupFormPage(params) {
  return request({
    url: `/cloud-upms/cg/form/page`,
    method: "get",
    params,
  })
}

// 查询 list
export function getGroupFormList(params) {
  return request({
    url: `/cloud-upms/cg/form/list`,
    method: "get",
    params,
  })
}

// 根据type+当前登陆人信息获取list
export function getCurrentFormByType(params) {
  return request({
    url: `/cloud-upms/cg/form/list/current`,
    method: "get",
    params,
  })
}

// 新增
export function addGroupForm(data) {
  return request({
    url: `/cloud-upms/cg/form`,
    method: "post",
    data,
  })
}

// 删除
export function delGroupForm(id) {
  return request({
    url: `/cloud-upms/cg/form/${id}`,
    method: "delete",
  })
}

// 获取协作组下机构科室列表

export function getGroupDeptList(params) {
  return request({
    url: `/cloud-upms/coop/group/user/list/org/dept`,
    method: "get",
    params,
  })
}

/*
 专病库管理

*/

// 根据专病获取大协作组
export function getBigGroupList(params) {
  return request({
    url: `/cloud-upms/sys/sdd/manage/get/big/grounp/list`,
    method: "get",
    params,
  })
}

// 获取大协作组下小协作组、科室

export function getAllGroupList(params) {
  return request({
    url: `/cloud-upms/sys/sdd/manage/get/All/Coop/grounp/list`,
    method: "get",
    params,
  })
}

/*
 导出字段配置

*/

// 根据 协作组id + 表code 查询系统(所有)字段list
export function getTableFields(params) {
  return request({
    url: `/cloud-upms/field/dict/sys/list/group/table`,
    method: "get",
    params,
  })
}

// 根据表code获取已经配置的字段list(导出字段配置)
export function getExportConfigFields(params) {
  return request({
    url: `/disease-data/export/field/list`,
    method: "get",
    params,
  })
}

// 导出字段配置批量保存

export function setExportFields({ tableCode, tableName, groupId }, data) {
  return request({
    url: `/disease-data/export/field/batch?tableCode=${tableCode}&tableName=${tableName}&groupId=${groupId}`,
    method: "post",
    data,
  })
}
// 导出数据
export function exportPatient(data) {
  return request({
    url: `/disease-data/export/patient/list`,
    method: "post",
    data,
    responseType: "blob",
  })
}

/*
 质控配置

*/
// 根据表code获取已经配置的字段list(质控字段配置)
export function getQcConfigFields(params) {
  return request({
    url: `/disease-data/auto/quality/rule/list`,
    method: "get",
    params,
  })
}
// 获取已经配置过的协作组列表(质控字段配置)
export function getQcGroupOption(params) {
  return request({
    url: `/disease-data/auto/quality/rule/group/option`,
    method: "get",
    params,
  })
}

// 质控字段配置批量保存

export function setQcConfigFields({ tableCode, tableName, groupId }, data) {
  return request({
    url: `/disease-data/export/field/batch?tableCode=${tableCode}&tableName=${tableName}&groupId=${groupId}`,
    method: "post",
    data,
  })
}

// 质控字段配置单个保存
export function setQcConfigField(data) {
  return request({
    url: `/disease-data/auto/quality/rule/save`,
    method: "post",
    data,
  })
}

// 引用其他机构协作组配置

export function setCloneConf(data) {
  return request({
    url: `/disease-data/auto/quality/rule/clone`,
    method: "post",
    data,
  })
}

// 删除配置
export function delConf(id) {
  return request({
    url: `/disease-data/auto/quality/rule/${id}`,
    method: "delete",
  })
}

/*
 质控方案

*/
// 新增/修改
export function setQualityPlan(data) {
  return request({
    url: `/disease-data/auto/quality/plan/addOrUpdate`,
    method: "post",
    data,
  })
}

// 列表
export function getQualityPlan(params) {
  return request({
    url: `/disease-data/auto/quality/plan/list`,
    method: "get",
    params,
  })
}

// 启用/禁用
export function setPlanStatus(params) {
  return request({
    url: `/disease-data/auto/quality/plan/enable`,
    method: "get",
    params,
  })
}

// 质控报告分页
export function getQualityReport(params) {
  return request({
    url: `/disease-data/auto/quality/report/page`,
    method: "get",
    params,
  })
}

// 质控方案报告管理导出
export function exportQuality(id) {
  return request({
    url: `/disease-data/auto/quality/report/export?id=${id}`,
    method: "post",
    responseType: "blob",
  })
}

// 质控方案报告数据分析报表
export function getQualityAnalyze(id) {
  return request({
    url: `/disease-data/auto/quality/report/analyze?id=${id}`,
    method: "get",
  })
}

/*
 质控数据管理

*/

// 列表
export function getQualityPage(params) {
  return request({
    url: `/disease-data/auto/patient/quality/page`,
    method: "get",
    params,
  })
}

// 质控数据管理批量质控
export function auditQuality(data) {
  return request({
    url: `/disease-data/auto/patient/quality/batchControl`,
    method: "post",
    data,
  })
}

// 质控数据管理详情查询
export function getQualityDetail(patientId) {
  return request({
    url: `/disease-data/auto/patient/quality/detail/${patientId}`,
    method: "get",
  })
}

/*
 协作组参数配置

*/

// 协作组参数配置新增/修改
export function setParamConfig(data) {
  return request({
    url: `/disease-data/param/config`,
    method: "post",
    data,
  })
}

// 协作组参数配置列表
export function getParamConfigList(params) {
  return request({
    url: `/disease-data/param/config/page`,
    method: "get",
    params,
  })
}

// 删除配置
export function delParamConfig(id) {
  return request({
    url: `/disease-data/param/config?id=${id}`,
    method: "delete",
  })
}
