import request from "@/utils/request"
import { contentType } from "@/config/settings"

export function login(params) {
  let headers = {
    "Content-Type": contentType,
    Authorization: "Basic YXBwOmNsb3VkX2FwcA==",
  }
  return request({
    url: `/cloud-auth/oauth/token?grant_type=password&password=${params.password}&scope=server&username=${params.userName}`,
    method: "post",
    headers: headers,
  })
}

export function logout() {
  return request({
    url: "/cloud-auth/token/logout",
    method: "delete",
  })
}

export function getUserPage(params = {}) {
  return request({
    url: "/cloud-upms/user/base/page",
    method: "get",
    params,
  })
}

export function addUser(data = {}) {
  return request({
    url: "/cloud-upms/user/base",
    method: "post",
    data,
  })
}

export function delUser(id) {
  return request({
    url: `/cloud-upms/user/base/${id}`,
    method: "delete",
  })
}

// 获取用户角色信息
export function getUserInfo(params = {}) {
  return request({
    url: "/cloud-upms/user/base/info",
    method: "get",
    params,
  })
}
// 设置用户角色信息
export function setUserRole(data = {}) {
  return request({
    url: "/cloud-upms/user/base/role",
    method: "post",
    data,
  })
}

export function getHprolePage(params = {}) {
  return request({
    url: "/cloud-upms//sys/role/page",
    method: "get",
    params,
  })
}

export function getHproleDetail(id) {
  return request({
    url: `/cloud-upms//sys/role/${id}`,
    method: "get",
  })
}
export function delHprole(id) {
  return request({
    url: `/cloud-upms//sys/role/${id}`,
    method: "delete",
  })
}

export function addHprole(data = {}) {
  return request({
    url: "/cloud-upms//sys/role",
    method: "post",
    data,
  })
}

// 获取当前用户
export function getUserCurrent() {
  return request({
    url: "/cloud-upms/user/base/info/current",
    method: "get",
  })
}

// 修改密码

export function editPwd(data = {}) {
  return request({
    url: "/cloud-upms/user/base/password",
    method: "put",
    data,
  })
}
export function resetPassword(id) {
  return request({
    url: `/cloud-upms/user/base/reset/password?userId=${id}`,
    method: "put",
  })
}

// 操作限制检查
export function getLimitCheck() {
  return request({
    url: "/cloud-upms/user/base/option/limit/check",
    method: "put",
  })
}

// 确认密码
export function confirmPwd(password) {
  return request({
    url: `/cloud-upms/user/base/confirm/password?password=${password}`,
    method: "put",
  })
}

// 单点登录接口
export function ssoLogin(token) {
  return request({
    url: `/cloud-auth/mobile/token/social?mobile=cs@token@${token}&grant_type=mobile`,
    method: "post",
    headers: {
      "Content-Type": contentType,
      Authorization: "Basic dGVzdDp0ZXN0",
    },
  })
}

//异常反馈
export function getAbnormalList(params) {
  return request({
    url: `/disease-data/sys/message/exception/feedBack/select/all/msg`,
    method: "get",
    params,
  })
}

// 修改系统信息-点击单条消息（进行已读操作）
export function setAbnormalStatus(params) {
  return request({
    url: `/disease-data/sys/message/exception/feedBack/do/read`,
    method: "get",
    params,
  })
}

// 查看系统信息-未读信息数目
export function getFeedBackNumber(id) {
  return request({
    url: `/disease-data/sys/message/exception/feedBack/select/unread/number?userId=${id}`,
    method: "get",
  })
}

// 获取B端日志
export function getLogPage(params = {}) {
  return request({
    url: "/cloud-upms/sys/log/page",
    method: "get",
    params,
  })
}
// 用户管理启用禁用
export function baseEnable(params = {}) {
  return request({
    url: "/cloud-upms/user/base/enable",
    method: "get",
    params,
  })
}
// 获取消息列表
export function getMessage(params = {}) {
  return request({
    url: "/disease-data/sys/message/list",
    method: "get",
    params,
  })
}
// 获取驳回修改消息
export function getRefuteMessage(params) {
  return request({
    url: `/disease-data/sys/message/remind/${params}`,
    method: "get",
    // params,
  })
}
// 设置已读消息
export function setReadMessege(id) {
  return request({
    url: `/disease-data/sys/message/read`,
    method: "put",
  })
}
