import request from "@/utils/request"

/**
 * 筛查审核
 *
 *  */
///////////////筛查质控/////////////////////
//筛查已审核列表
export function getScreeningCheck(params = {}) {
  return request({
    url: "/disease-data/dataCheck/screening/check",
    method: "get",
    params,
  })
}
//筛查待审核列表
export function getScreeningUncheck(params = {}) {
  return request({
    url: "/disease-data/dataCheck/screening/unCheck",
    method: "get",
    params,
  })
}

//筛查病例待审核(用户)
export function getScreeningUser(id) {
  return request({
    url: `/disease-data/dataCheck/screening/unCheck/detail/${id}`,
    method: "get",
  })
}
//筛查病例审核
export function putScreeningCheck(data = {}) {
  return request({
    url: "/disease-data/dataCheck/screening/uncheck",
    method: "put",
    data,
  })
}
// 获取意见标签
export function getSysCheckNote() {
  return request({
    url: "/disease-data/sysCheckNote",
    method: "get",
  })
}
// 删除意见标签
export function saveSysCheckNote(data = {}) {
  return request({
    url: "/disease-data/sysCheckNote",
    method: "post",
    data,
  })
}

//修改筛查病例审核意见
export function putScreeningCheckAdvice(data = {}) {
  return request({
    url: "/disease-data/dataCheck/screening/check/advice",
    method: "put",
    data,
  })
}
