import request from "@/utils/request"

/* 患者数据 */
export function getPatientPage(params = {}) {
  let url = "/disease-data/data/patient/page?"
  let keys = Object.keys(params)
  for (let key of keys) {
    url += `${encodeURIComponent(key)}=${params[key]}&`
  }
  url = url.substring(0, url.length - 1)
  return request({
    url: url,
    method: "get",
  })
}

// 随访分页
export function getPatientFollowPage(params = {}) {
  let url = "/disease-data/data/patient/follow/page?"
  let keys = Object.keys(params)
  for (let key of keys) {
    url += `${encodeURIComponent(key)}=${params[key]}&`
  }
  url = url.substring(0, url.length - 1)
  return request({
    url: url,
    method: "get",
  })
}

export function delPatient(id) {
  return request({
    url: `/cloud-upms/sys/menu/${id}`,
    method: "delete",
  })
}
// 填报
export function addPatient(data = {}, type = "") {
  return request({
    url: `/disease-data/data/patient/${type}`,
    method: "post",
    data,
  })
}

// 随访录入
export function addFollowPatient(data = {}, type = "") {
  return request({
    url: `/disease-data/data/patient/follow/${type}`,
    method: "post",
    data,
  })
}

// 删除草稿
export function deletePatient(data) {
  return request({
    url: `/disease-data/data/patient/${data}`,
    method: "delete",
  })
}

/* 患者数据详情 */
export function getPatientDetail(params = {}) {
  return request({
    url: "/disease-data/data/patient/info",
    method: "get",
    params,
  })
}

/* 随访患者数据详情 */
export function getFollowDetail(params = {}) {
  return request({
    url: "/disease-data/data/patient/follow/info",
    method: "get",
    params,
  })
}

/*  获取表单填报记录list*/
export function getRecordList(params = {}) {
  return request({
    url: "/disease-data/data/patient/form/record/list",
    method: "get",
    params,
  })
}

// 患者质控列表 分页查询

export function getQcPage(params = {}) {
  return request({
    url: "/disease-data/data/qc/page",
    method: "get",
    params,
  })
}

// 质控
export function qcPatient(data = {}, type = "") {
  return request({
    url: `/disease-data/data/qc`,
    method: "post",
    data,
  })
}

// 获取九院口腔癌患者信息（同屏对照使用）

export function getJYpatientInfo(params = {}) {
  return request({
    url: "/jiuyuan-gather/patient/kqa/info",
    method: "get",
    params,
  })
}

// 获取九院口腔癌随访表（同屏对照使用）

export function getJYFollowInfo(params = {}) {
  return request({
    url: "/jiuyuan-gather/patient/kqa/follow/info",
    method: "get",
    params,
  })
}

// 获取同济口腔 牙周病（yzb） | 口腔癌（kqa） 患者信息（同屏对照使用）

export function getTJpatientInfo(params = {}, diseases = "yzb") {
  return request({
    url: `/tjkq-gather/patient/${diseases}/info`,
    method: "get",
    params,
  })
}

// 获取九院牙周炎患者信息（同屏对照使用）

export function getJYyzyPatientInfo(params = {}) {
  return request({
    url: "/jiuyuan-gather/patient/yzy/info",
    method: "get",
    params,
  })
}

// 获取急性胰腺炎患者信息/检查信息/术治疗（同屏对照使用）
export function getJxyzyPatientInfo(type, params = {}) {
  return request({
    url: `/changhai-gather/patient/${type}/info`,
    method: "get",
    params,
  })
}
// 获取中山医院病历/检查信息/治疗（同屏对照使用）
export function getZsyzyPatientInfo(params = {}) {
  return request({
    url: "/zsyzy-gather/patient/yzb/info",
    method: "get",
    params,
  })
}

// 急性胰腺炎-评分表

// 评分表新增修改
export function saveApScore(data = {}) {
  return request({
    url: `disease-data/ap/score`,
    method: "post",
    data,
  })
}

// 根据patientId查询评分表数据

export function getApScore(patientId) {
  return request({
    url: `/disease-data/ap/score/list?patientId=${patientId}`,
    method: "get",
  })
}

// 根据patientId+type查询(评分趋势图用)
export function getApScoreTypeList(params = {}) {
  return request({
    url: "disease-data/ap/score/type/list",
    method: "get",
    params,
  })
}

// 根据patientId, scoreId查询detailList
export function getApScoreDetailList(params = {}) {
  return request({
    url: "/disease-data/ap/score/detail/list",
    method: "get",
    params,
  })
}

// 获取随访计划右侧列表
export function getFollowList(params = {}) {
  return request({
    url: "/disease-data/data/patient/log/list",
    method: "get",
    params,
  })
}
