import request from "@/utils/request"

/**
 * 随访
 *
 *  */
//随访查询 列表
export function getFollowSearch(params = {}) {
  return request({
    url: "/disease-data/follow/search",
    method: "get",
    params,
  })
}
//随访调查 列表
export function getFollowSurvey(params = {}) {
  return request({
    url: "/disease-data/follow/survey",
    method: "get",
    params,
  })
}
///////////////审核质控/////////////////////
//随访已审核列表
export function getFollowCheck(params = {}) {
  return request({
    url: "/disease-data/dataCheck/follow/check",
    method: "get",
    params,
  })
}
//随访待审核列表
export function getFollowUncheck(params = {}) {
  return request({
    url: "/disease-data/dataCheck/follow/unCheck",
    method: "get",
    params,
  })
}
//随访病例待审核(详情数据)
export function getFollowUnCheckDetail(id) {
  return request({
    url: `/disease-data/dataCheck/follow/unCheck/detail/${id}`,
    method: "get",
  })
}
//随访病例审核
export function putFollowCheck(data = {}) {
  return request({
    url: "/disease-data/dataCheck/follow/uncheck",
    method: "put",
    data,
  })
}
//修改随访审核意见
export function putFollowCheckAdvice(data = {}) {
  return request({
    url: "/disease-data/dataCheck/follow/check/advice",
    method: "put",
    data,
  })
}

// 随访查询详情list
export function getFollowRecord(params = {}) {
  return request({
    url: "/disease-data/follow/search/detail",
    method: "get",
    params,
  })
}
