import {
  articleEnable,
  deleteArticle,
  addArticle,
} from "@/api/operation-management"

const mixin = {
  data() {
    return {
      readOnly: true,
      addVisible: false,
      deleteVisible: false,
      deleteId: "",
      form: {
        status: 1,
      },
    }
  },
  methods: {
    // 添加文章
    addMedical() {
      this.readOnly = false
      this.addVisible = true
    },
    // 查看
    viewMedical(data) {
      this.readOnly = true
      this.form = { ...data }
      this.addVisible = true
    },
    // 编辑医联体
    editMedical(data) {
      this.readOnly = false
      this.form = JSON.parse(JSON.stringify(data))
      this.addVisible = true
    },
    // 启用状态
    openChage(data, index) {
      console.log(data, index)
      let params = {
        id: data.id,
        status: data.status ? 1 : 0,
      }
      articleEnable(params).then((res) => {
        if (res.code == 1) {
          // this.$message.success("保存成功")
          this.getArticleList()
        }
      })
    },
    resetForm() {
      this.$refs["form"].resetFields()
      this.form = {
        status: 1,
      }
    },
    submitForm(moduleType) {
      this.$refs["form"].validate((valid) => {
        if (valid) {
          addArticle({
            ...this.form,
            moduleType: moduleType,
          }).then((res) => {
            if (res.code == 1) {
              this.addVisible = false
              this.$refs["form"].resetFields()
              this.form = {
                status: 1,
              }
              this.getArticleList()
            }
          })
        } else {
          console.log("error submit!!")
          return false
        }
      })
    },
    // 删除
    deleteFunc(data) {
      console.log(data)
      this.deleteVisible = true
      this.deleteId = data.id
    },
    // 确认删除
    confirmDelete() {
      this.deleteVisible = false
      deleteArticle(this.deleteId)
        .then((res) => {
          if (res.code == 1) {
            this.$message.success("删除成功")
            this.getArticleList()
          }
        })
        .catch(() => {})
    },
  },
}
export default mixin
