import { debounce } from "@/utils"

export default {
  data() {
    return {
      $_sidebarElm: null,
      $_resizeHandler: null,
      toTopHeight: 0,
      clientHeight: 990,
    }
  },
  computed: {
    maxTableHeight() {
      const h = this.clientHeight - this.toTopHeight - 140
      return h >= 300 ? h : 300
    },
  },
  mounted() {
    this.$_resizeHandler = debounce(() => {
      this.getClientHeight()
      this.getToTopHeight()
    }, 200)
    this.$_initResizeEvent()
  },
  beforeDestroy() {
    this.$_destroyResizeEvent()
  },
  // to fixed bug when cached by keep-alive
  // https://github.com/PanJiaChen/vue-element-admin/issues/2116
  activated() {
    this.$_initResizeEvent()
  },
  deactivated() {
    this.$_destroyResizeEvent()
  },
  methods: {
    getToTopHeight() {
      const el = this.$refs["selftab"].$el
      this.toTopHeight = el.getBoundingClientRect().top
    },
    getClientHeight() {
      this.clientHeight =
        window.innerHeight ||
        document.documentElement.clientHeight ||
        document.body.clientHeight
    },
    // use $_ for mixins properties
    // https://vuejs.org/v2/style-guide/index.html#Private-property-names-essential
    $_initResizeEvent() {
      this.getClientHeight()
      this.getToTopHeight()
      window.addEventListener("resize", this.$_resizeHandler)
    },
    $_destroyResizeEvent() {
      window.removeEventListener("resize", this.$_resizeHandler)
    },
  },
}
