formJson = {
  column: [],
  labelPosition: "left",
  labelSuffix: "：",
  labelWidth: 100,
  gutter: 0,
  menuBtn: true,
  submitBtn: true,
  submitText: "下一步",
  emptyBtn: false,
  emptyText: "清空",
  nextTabBtn: true,
  nextTabText: "下一页",
  menuPosition: "center",
  group: [
    {
      label: "筛查点信息",
      prop: "1669195600018_27976",
      arrow: true,
      collapse: true,
      display: true,
      labelWidth: 8,
      column: [
        {
          type: "input",
          display: true,
          importantField: false,
          styles: {},
          autoRequired: 0,
          personalRequired: 0,
          label: "医联体编号",
          prop: "union_id",
          fieldType: "varchar",
          fieldLength: "127",
          tableName: "入排选标准",
          tableCode: "gas_exclusion_criteria",
          tableId: "1595341111042252802",
          notFilter: false,
          cType: "",
          subfield: false,
          span: 24,
          width: 12,
          required: true,
          rules: [{ required: true, message: "医联体编号必须填写" }],
          xs: 24,
          sm: 24,
          md: 24,
        },
        {
          type: "input",
          display: true,
          importantField: false,
          styles: {},
          prop: "screen_point_number",
          label: "筛查点编号",
          fieldType: "varchar",
          fieldLength: "20",
          tableName: "入排选标准",
          tableCode: "gas_exclusion_criteria",
          tableId: "1595341111042252802",
          notFilter: false,
          cType: "",
          subfield: false,
          span: 24,
          width: 12,
          rules: [{ required: true, message: "筛查点编号必须填写" }],
          required: true,
          xs: 24,
          sm: 24,
          md: 24,
        },
      ],
    },
    {
      label: "一、入选标准",
      prop: "1669195610048_55035",
      arrow: true,
      collapse: true,
      display: true,
      labelWidth: 8,
      column: [
        {
          type: "date",
          display: true,
          importantField: false,
          styles: {},
          prop: "birthday",
          label: "出生日期",
          fieldType: "date",
          fieldLength: "",
          format: "yyyy-MM-dd",
          valueFormat: "yyyy-MM-dd",
          dicType: "",
          tableName: "患者信息",
          tableCode: "gas_patient_info",
          tableId: "1595347991491833857",
          notFilter: false,
          cType: "",
          subfield: false,
          autoRequired: 0,
          personalRequired: 1,
          span: 24,
          width: 12,
          required: true,
          rules: [
            { required: true, message: "出生日期必须填写" },
            {
              validator: function checkAge(rule, value, callback) {
                if (!value) {
                  return callback(new Error("请选择出生日期"))
                }
                var birthday = new Date(value.replace(/-/g))
                var d = new Date()
                var age =
                  d.getFullYear() -
                  birthday.getFullYear() -
                  (d.getMonth() < birthday.getMonth() ||
                  (d.getMonth() == birthday.getMonth() &&
                    d.getDate() < birthday.getDate())
                    ? 1
                    : 0)
                console.log(age)
                if (age < 40 || age > 80) {
                  callback(new Error("年龄不符合筛查条件"))
                } else {
                  callback()
                }
              },
              trigger: "change",
            },
          ],
          disabled: false,
          pattern: "checkAge",
          xs: 24,
          sm: 24,
          md: 24,
        },
        {
          type: "radio",
          display: true,
          importantField: false,
          styles: {},
          autoRequired: 0,
          personalRequired: 0,
          dicData: [
            {
              label: "是",
              value: "1",
              id: "1595347527757000705",
              parentId: "",
            },
            {
              label: "否",
              value: "0",
              id: "1595347502595371010",
              parentId: "",
            },
          ],
          dynamicshSet: [],
          dicType: "d-sf",
          props: { label: "label", value: "value" },
          prop: "is_know",
          label: "知情同意",
          fieldType: "tinyint",
          fieldLength: "2",
          tableName: "入排选标准",
          tableCode: "gas_exclusion_criteria",
          tableId: "1595341111042252802",
          notFilter: false,
          cType: "",
          subfield: false,
          span: 24,
          width: 12,
          required: true,
          rules: [{ required: true, message: "请选择知情同意" }],
        },
      ],
    },
    {
      label: "二、排除标准",
      prop: "1669707112356_13663",
      arrow: true,
      collapse: true,
      display: true,
      labelWidth: 8,
      column: [
        {
          type: "radio",
          display: true,
          importantField: false,
          styles: {},
          autoRequired: 0,
          personalRequired: 0,
          label: "距上次胃镜检查间隔时间一年内",
          prop: "is_one_year",
          dicData: [
            {
              label: "是",
              value: "1",
              id: "1595347527757000705",
              parentId: "",
            },
            {
              label: "否",
              value: "0",
              id: "1595347502595371010",
              parentId: "",
            },
          ],
          dynamicshSet: [],
          dicType: "d-sf",
          props: { label: "label", value: "value" },
          fieldType: "tinyint",
          fieldLength: "2",
          tableName: "入排选标准",
          tableCode: "gas_exclusion_criteria",
          tableId: "1595341111042252802",
          notFilter: false,
          cType: "",
          subfield: false,
          span: 24,
          labelWidth: 850,
          width: 24,
          xs: 24,
          sm: 24,
          md: 24,
        },
        {
          type: "radio",
          display: true,
          importantField: false,
          styles: {},
          label: "胃大部切除术手术史",
          prop: "is_subtotal_history",
          fieldType: "tinyint",
          fieldLength: "2",
          dicData: [
            {
              label: "是",
              value: "1",
              id: "1595347527757000705",
              parentId: "",
            },
            {
              label: "否",
              value: "0",
              id: "1595347502595371010",
              parentId: "",
            },
          ],
          dynamicshSet: [],
          dicType: "d-sf",
          props: { label: "label", value: "value" },
          tableName: "入排选标准",
          tableCode: "gas_exclusion_criteria",
          tableId: "1595341111042252802",
          notFilter: false,
          cType: "",
          subfield: false,
          span: 24,
          labelWidth: 850,
          width: 24,
          xs: 24,
          sm: 24,
          md: 24,
          lg: 24,
          autoRequired: 0,
          personalRequired: 0,
        },
        {
          type: "radio",
          display: true,
          importantField: false,
          styles: {},
          prop: "is_ppi",
          label:
            "两周内服用PPI（埃索美拉唑、泮托拉唑、雷贝拉唑、兰索拉唑等）或H2受体拮抗剂（法莫替丁等）",
          dicData: [
            {
              label: "是",
              value: "1",
              id: "1595347527757000705",
              parentId: "",
            },
            {
              label: "否",
              value: "0",
              id: "1595347502595371010",
              parentId: "",
            },
          ],
          dynamicshSet: [],
          dicType: "d-sf",
          props: { label: "label", value: "value" },
          fieldType: "tinyint",
          fieldLength: "2",
          tableName: "入排选标准",
          tableCode: "gas_exclusion_criteria",
          tableId: "1595341111042252802",
          notFilter: false,
          cType: "",
          subfield: false,
          span: 24,
          labelWidth: 850,
          width: 24,
          xs: 24,
          sm: 24,
          md: 24,
          lg: 24,
        },
        {
          type: "radio",
          display: true,
          importantField: false,
          styles: {},
          dicData: [
            {
              label: "是",
              value: "1",
              id: "1595347527757000705",
              parentId: "",
            },
            {
              label: "否",
              value: "0",
              id: "1595347502595371010",
              parentId: "",
            },
          ],
          dynamicshSet: [],
          dicType: "d-sf",
          props: { label: "label", value: "value" },
          prop: "is_symptom",
          label:
            "有下列一种或多种症状： 6个月内缺铁性贫血；12个月内消化道出血（黑便、血便等）；体重减轻（非减肥原因6个月内体重减轻≥4.5Kg）；经常性腹泻；吞咽困难或哽噎感；腹部肿块",
          fieldType: "tinyint",
          fieldLength: "2",
          tableName: "入排选标准",
          tableCode: "gas_exclusion_criteria",
          tableId: "1595341111042252802",
          notFilter: false,
          cType: "",
          subfield: false,
          span: 24,
          labelWidth: 850,
          width: 24,
          xs: 24,
          sm: 24,
          md: 24,
          lg: 24,
        },
        {
          type: "radio",
          display: true,
          importantField: false,
          styles: {},
          dicData: [
            {
              label: "是",
              value: "1",
              id: "1595347527757000705",
              parentId: "",
            },
            {
              label: "否",
              value: "0",
              id: "1595347502595371010",
              parentId: "",
            },
          ],
          dynamicshSet: [],
          dicType: "d-sf",
          props: { label: "label", value: "value" },
          prop: "is_disease",
          label:
            "有以下任何一种疾病史 食管癌、胃癌、结直肠肿瘤、炎症性肠病、其它器官恶性肿瘤（乳腺、卵巢、子宫及泌尿系统等）",
          fieldType: "tinyint",
          fieldLength: "2",
          tableName: "入排选标准",
          tableCode: "gas_exclusion_criteria",
          tableId: "1595341111042252802",
          notFilter: false,
          cType: "",
          subfield: false,
          span: 24,
          labelWidth: 850,
          width: 24,
          xs: 24,
          sm: 24,
          md: 24,
          lg: 24,
        },
        {
          type: "radio",
          display: true,
          importantField: false,
          styles: {},
          dicData: [
            {
              label: "是",
              value: "1",
              id: "1595347527757000705",
              parentId: "",
            },
            {
              label: "否",
              value: "0",
              id: "1595347502595371010",
              parentId: "",
            },
          ],
          dynamicshSet: [],
          dicType: "d-sf",
          props: { label: "label", value: "value" },
          prop: "is_tumour",
          label: "影像、肿瘤标志物等检查高度怀疑罹患肿瘤可能",
          fieldType: "tinyint",
          fieldLength: "2",
          tableName: "入排选标准",
          tableCode: "gas_exclusion_criteria",
          tableId: "1595341111042252802",
          notFilter: false,
          cType: "",
          subfield: false,
          span: 24,
          labelWidth: 850,
          width: 24,
          xs: 24,
          sm: 24,
          md: 24,
          lg: 24,
        },
        {
          type: "radio",
          display: true,
          importantField: false,
          styles: {},
          dicData: [
            {
              label: "是",
              value: "1",
              id: "1595347527757000705",
              parentId: "",
            },
            {
              label: "否",
              value: "0",
              id: "1595347502595371010",
              parentId: "",
            },
          ],
          dynamicshSet: [],
          dicType: "d-sf",
          props: { label: "label", value: "value" },
          prop: "is_Incomplete",
          label: "严重心、肺、肝、肾功能不全，或严重精神疾患",
          fieldType: "tinyint",
          fieldLength: "2",
          tableName: "入排选标准",
          tableCode: "gas_exclusion_criteria",
          tableId: "1595341111042252802",
          notFilter: false,
          cType: "",
          subfield: false,
          span: 24,
          labelWidth: 850,
          width: 24,
          xs: 24,
          sm: 24,
          md: 24,
          lg: 24,
        },
      ],
    },
  ],
}
