const state = {
  fontSize: localStorage.getItem("fontSize") || 14,
  selectedIndex: sessionStorage.getItem("selectedIndex") || "",
  refreshFlag: 0,
}
const getters = {
  fontSize: (state) => state.fontSize,
  selectedIndex: (state) => state.selectedIndex,
  refreshFlag: (state) => state.refreshFlag,
}
const mutations = {
  setFontSize(state, fontSize) {
    state.fontSize = fontSize
  },
  setSelectedIndex(state, selectedIndex) {
    state.selectedIndex = selectedIndex
    sessionStorage.setItem("selectedIndex", selectedIndex)
  },
  removeSelectedIndex() {
    state.selectedIndex = ""
    sessionStorage.removeItem("selectedIndex")
  },
  setRefreshFlag(state, refreshFlag) {
    state.refreshFlag = refreshFlag
  },
}
const actions = {}
export default {
  state,
  getters,
  mutations,
  actions,
}
