/**
 * @copyright chuzhixin 1204505056@qq.com
 * @description 路由拦截状态管理，目前两种模式：all模式与intelligence模式，其中partialRoutes是菜单暂未使用
 */
import { asyncRoutes, constantRoutes } from "@/router"
import {
  filterAllRoutes,
  filterAsyncRoutes,
  routesFormat,
} from "@/utils/handleRoutes"

const state = {
  routes: [],
  partialRoutes: [],
}
const getters = {
  routes: (state) => state.routes,
  partialRoutes: (state) => state.partialRoutes,
}
const mutations = {
  setRoutes(state, routes) {
    state.routes = constantRoutes.concat(routes)
  },
  setAllRoutes(state, routes) {
    state.routes = constantRoutes.concat(routes)
  },
  setPartialRoutes(state, routes) {
    state.partialRoutes = constantRoutes.concat(routes)
  },
}
const actions = {
  async setRoutes({ commit }, permissions) {
    let accessedRoutes = []
    accessedRoutes = asyncRoutes
    commit("setRoutes", accessedRoutes)
    return accessedRoutes
  },
  async setAllRoutes({ commit }, menuList) {
    let accessRoutes = routesFormat(menuList)
    let replenishRoutes = [
      {
        path: "*",
        redirect: "/404",
        hidden: true,
      },
    ]
    if (accessRoutes && accessRoutes[0]) {
      replenishRoutes.unshift({
        hidden: true,
        path: "/",
        redirect: {
          name: accessRoutes[0].children[0].name,
        },
      })
    }
    accessRoutes = accessRoutes.concat(replenishRoutes)
    commit("setAllRoutes", accessRoutes)
    return accessRoutes
  },
  setPartialRoutes({ commit }, accessRoutes) {
    commit("setPartialRoutes", accessRoutes)
    return accessRoutes
  },
}
export default {
  state,
  getters,
  mutations,
  actions,
}
